unit HitCounter;
// opcenito za developere, login, dodavanje, details
interface

uses System.Web.UI, DateUtils, SysUtils, StrUtils, System.Configuration, System.Data, System.Data.SqlClient;

type THitCounter = Class
		function GetConnectionString:string;
    function IncToday(sPageName:string) : integer; // povecaj hit danas
    function GetToday(sPageName:string) : integer; // povecaj hit danas
//		function GetToday : integer; // number of hits today
    function GetThisWeek : integer; // hits this week (zadnjih 7 dana)
    function GetTotal : integer; // total hits
end;

implementation

function THitCounter.GetConnectionString: string;
begin
	Result:=ConfigurationSettings.AppSettings.Get('ConnectionString')
end;

function THitCounter.GetThisWeek: integer;
var
	myConnection : SqlConnection;
	myCommand : SqlCommand;
	parameterHits, parameterDatum: SqlParameter;
	Y,M,D: word;
begin
	myConnection := SqlConnection.Create(GetConnectionString);
 	myCommand := SqlCommand.Create('HitsGetThisWeek', myConnection);
	myCommand.CommandType := CommandType.StoredProcedure;

  parameterHits := SqlParameter.Create('@Hits', SqlDbType.Int, 4);
  parameterHits.Direction := ParameterDirection.Output;
  myCommand.Parameters.Add(parameterHits);

  parameterDatum := SqlParameter.Create('@Datum', SqlDbType.SmallDateTime);
	DecodeDate(Date, Y, M, D);
  parameterDatum.Value := DateTime.FromOADate(IncDay(Date,-7));
  myCommand.Parameters.Add(parameterDatum);
	

	try
    myConnection.Open;
    myCommand.ExecuteNonQuery;
    myConnection.Close;

    Result := Integer(parameterHits.Value);
  except
    Result := 0;
  end
end;//function HitCounter.GetThisWeek

function THitCounter.GetTotal: integer;
var
	myConnection : SqlConnection;
	myCommand : SqlCommand;
	parameterHits: SqlParameter;
//	Y,M,D: word;
begin
	myConnection := SqlConnection.Create(GetConnectionString);
 	myCommand := SqlCommand.Create('HitsGetTotal', myConnection);
	myCommand.CommandType := CommandType.StoredProcedure;

  parameterHits := SqlParameter.Create('@Hits', SqlDbType.Int, 4);
  parameterHits.Direction := ParameterDirection.Output;
  myCommand.Parameters.Add(parameterHits);

	try
    myConnection.Open;
    myCommand.ExecuteNonQuery;
    myConnection.Close;

    Result := Integer(parameterHits.Value);
  except
    Result := 0;
  end
end;//function HitCounter.GetTotal


function THitCounter.IncToday(sPageName:string): integer;
var
	myConnection : SqlConnection;
	myCommand : SqlCommand;
	parameterHits, parameterDatum, parameterPageName : SqlParameter;
	Y,M,D: word;
begin
	myConnection := SqlConnection.Create(GetConnectionString);
 	myCommand := SqlCommand.Create('HitsIncToday', myConnection);
	myCommand.CommandType := CommandType.StoredProcedure;

  parameterHits := SqlParameter.Create('@Hits', SqlDbType.Int, 4);
  parameterHits.Direction := ParameterDirection.Output;
  myCommand.Parameters.Add(parameterHits);

  parameterDatum := SqlParameter.Create('@Datum', SqlDbType.SmallDateTime);
	DecodeDate(Date, Y, M, D);
//  parameterDatum.Value := TDateTime(IntToStr(M) + '/'+ IntToStr(D) + '/' + IntToStr(Y));
  parameterDatum.Value := DateTime.FromOADate(Date);
  myCommand.Parameters.Add(parameterDatum);
	
  parameterPageName := SqlParameter.Create('@PageName', SqlDbType.NVarChar, 50);
  parameterPageName.Value := sPageName;
  myCommand.Parameters.Add(parameterPageName);
	
	try
    myConnection.Open;
    myCommand.ExecuteNonQuery;
    myConnection.Close;

    Result := Integer(parameterHits.Value);
  except
    Result := 0;
  end
end;//function HitCounter.IncToday

function THitCounter.GetToday(sPageName:string): integer;
var
	myConnection : SqlConnection;
	myCommand : SqlCommand;
	parameterHits, parameterDatum, parameterPageName : SqlParameter;
	Y,M,D: word;
begin
	myConnection := SqlConnection.Create(GetConnectionString);
 	myCommand := SqlCommand.Create('HitsGetToday', myConnection);
	myCommand.CommandType := CommandType.StoredProcedure;

  parameterHits := SqlParameter.Create('@Hits', SqlDbType.Int, 4);
  parameterHits.Direction := ParameterDirection.Output;
  myCommand.Parameters.Add(parameterHits);

  parameterDatum := SqlParameter.Create('@Datum', SqlDbType.SmallDateTime);
	DecodeDate(Date, Y, M, D);
//  parameterDatum.Value := TDateTime(IntToStr(M) + '/'+ IntToStr(D) + '/' + IntToStr(Y));
  parameterDatum.Value := DateTime.FromOADate(Date);
  myCommand.Parameters.Add(parameterDatum);
	
  parameterPageName := SqlParameter.Create('@PageName', SqlDbType.NVarChar, 50);
  parameterPageName.Value := sPageName;
  myCommand.Parameters.Add(parameterPageName);
	
	try
    myConnection.Open;
    myCommand.ExecuteNonQuery;
    myConnection.Close;

    Result := Integer(parameterHits.Value);
  except
    Result := 0;
  end
end;//function HitCounter.GetToday

end.
